--[[---------------------------------------------------------------------------
	Chocolatier Two Simulator: Character Actions
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------

function Speak(m)
	local t=m
	if not m then
		bsgDevWarning("No Speak table")
	elseif table.getn(m) < 1 then
		bsgDevWarning("Empty Speak table: "..tostring(m))
	elseif not m[1] then
		bsgDevWarning("Speak table contains null: "..tostring(m))
	else
		return function(c,d)
			if d then
				return "Speak: "..t
			else
				local k = t
				if type(k) == "table" then
					local i = bsgRandom(1, table.getn(k))
					k = k[i]
				end
				k = GetString(k) or ""
				DisplayDialog { "ui/chartalk.lua", char=c, body="#"..k, ok="ok" }
				return true
			end
		end
	end
end

-------------------------------------------------------------------------------

local function DoGiveTip(c,d)
	if d then
		return "GiveTip"
	else
		-- Give a tip only every 4 weeks max
		if (gSim.weeks - gSim.tip) > 3 then
			local tip = LTip:RandomTip()
			if tip then
				gSim.tip = gSim.weeks
				local m = tip:GetMessage()
				DisplayDialog { "ui/chartalk.lua", fullbody=m, char=c, ok="ok", }
				return true
			end
		end
		return false
	end
end

function GiveTip() return DoGiveTip end

-------------------------------------------------------------------------------

local function DoDicePlay(c,d)
	if d then
		return "PlayDice"
	else
		-- Gamble limits: $5000, once a week until MC
		if gSim.money > 5000 and (gSim.rank >= 4 or (gSim.weeks - gSim.gamble) > 1) then
			local yn = DisplayDialog { "ui/chartalk.lua", body="gamble_dice_yn", char=c, yes="yes",no="no" }
			if yn == "yes" then
				gSim.gamble = gSim.weeks
				DisplayDialog { "ui/gamble_dice.lua", char=c }
			else
				-- FIRSTPEEK: DiceGame, time-stamp, weeks, money, 0, 0, 0
				if fpWrite then fpWrite { "DiceGame", gSim.weeks, gSim.money, 0, 0, 0 } end
			end
			return true
		else
			return false
		end
	end
end

function PlayDice() return DoDicePlay end

-------------------------------------------------------------------------------

local function DoBonusPlay(c,d)
	if d then
		return "PlayBonus"
	else
		-- Gamble limits: $5000, once a week until MC
		if gSim.money > 5000 and (gSim.rank >= 4 or (gSim.weeks - gSim.gamble) > 1) then
			local yn = DisplayDialog { "ui/chartalk.lua", body="gamble_crate_yn", char=c, yes="yes",no="no" }
			if yn == "yes" then
				gSim.gamble = gSim.weeks
				DisplayDialog { "ui/gamble_bonus.lua", char=c }
			else
				-- FIRSTPEEK: CratesGame, time-stamp, weeks, money, 0, 0
				if fpWrite then fpWrite { "CratesGame", gSim.weeks, gSim.money, 0, 0 } end
			end
			return true
		else
			return false
		end
	end
end

function PlayBonus() return DoBonusPlay end
